/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.monitor;

import com.ibm.hwmca.base.monitor.MonitorAction;
import com.ibm.hwmca.base.monitor.MonitorCondition;
import com.ibm.hwmca.base.monitor.MonitorConstants;
import com.ibm.hwmca.base.monitor.MonitorMgr;
import com.ibm.hwmca.base.monitor.ObjectWrapper;
import com.ibm.hwmca.base.monitor.config.MonitorActionConfig;
import com.ibm.hwmca.base.monitor.config.MonitorActionTypeConfig;
import com.ibm.hwmca.base.monitor.config.MonitorConditionConfig;
import com.ibm.hwmca.base.monitor.config.MonitorConfig;
import com.ibm.hwmca.base.monitor.config.MonitorGroupConfig;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.TimerTaskExecutionControl;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MonitorTask
implements HMCTimerTask,
Runnable,
MonitorConstants {
    private static final String TRACE_MASKD = "XMONMNTD";
    private static final String TRACE_MASKF = "XMONMNTF";
    private static final String TRACE_MASKT = "XMONMNTT";
    private static final int MAX_UNEXPECTED_ERRORS_TO_LOG = 5;
    private MonitorGroupConfig monitorGroup;
    private HashMap actionTypes;
    private MonitorMgr monitorMgr;
    private int unexpectedErrors;

    MonitorTask(MonitorGroupConfig monitorGroup, HashMap actionTypes, MonitorMgr monitorMgr) {
        Object actionType = null;
        if (monitorGroup == null) {
            throw new IllegalArgumentException();
        }
        if (actionTypes == null) {
            throw new IllegalArgumentException();
        }
        this.monitorGroup = monitorGroup;
        this.actionTypes = actionTypes;
        this.monitorMgr = monitorMgr;
        this.unexpectedErrors = 0;
        Trace.trace(TRACE_MASKT, "<->MonitorTask(" + monitorGroup + ", " + actionTypes + ", " + monitorMgr + ")");
    }

    public static void main(String[] args) {
    }

    public void run(TimerTaskExecutionControl timerTaskExecutionControl, Object runParms) {
        Object task = null;
        Trace.trace(TRACE_MASKT, "->run(" + timerTaskExecutionControl + ", " + runParms + ")");
        new Thread((Runnable)this, "CCFW Monitor Thread").start();
        Trace.trace(TRACE_MASKT, "<-run(...)");
    }

    public void run() {
        block3: {
            ArrayList monitors = null;
            MonitorConfig monitor = null;
            ArrayList conditions = null;
            ArrayList actions = null;
            ObjectWrapper token = null;
            ArrayList actionsPerformed = null;
            Trace.trace(TRACE_MASKT, "-> run()");
            try {
                monitors = this.monitorGroup.getMonitors();
                actionsPerformed = new ArrayList();
                Iterator i = monitors.iterator();
                while (i.hasNext()) {
                    monitor = (MonitorConfig)i.next();
                    conditions = monitor.getConditions();
                    actions = monitor.getActions();
                    if (MonitorTask.allActionsPerformedAlready(actions, actionsPerformed) || this.maxSuccessesAlreadyForAllActions(actions, actionsPerformed) || !MonitorTask.isConditionsTrue(conditions, token = new ObjectWrapper())) continue;
                    this.runActions(actions, token, actionsPerformed);
                }
            }
            catch (Throwable t) {
                Trace.trace(TRACE_MASKF, "Unexpected throwable caught while running monitor group : " + t);
                Trace.trace(TRACE_MASKF, t);
                if (this.unexpectedErrors >= 5) break block3;
                new FrameworkLog(MonitorConstants.LOG_INFO, 3, t).log();
                ++this.unexpectedErrors;
            }
        }
        Trace.trace(TRACE_MASKT, "<- run(...)");
    }

    private static boolean isConditionsTrue(ArrayList conditions, ObjectWrapper token) {
        MonitorConditionConfig condition = null;
        boolean result = true;
        boolean atLeastOneConditionRun = false;
        Trace.trace(TRACE_MASKT, "-> isConditionsTrue(" + conditions + ", " + token + ")");
        Iterator i = conditions.iterator();
        while (i.hasNext()) {
            condition = (MonitorConditionConfig)i.next();
            if (!MonitorTask.isConditionTrue(condition, token)) {
                result = false;
                break;
            }
            atLeastOneConditionRun = true;
        }
        if (!atLeastOneConditionRun) {
            result = false;
        }
        Trace.trace(TRACE_MASKT, "-> isConditionsTrue(...) returning " + result);
        return result;
    }

    private static boolean isConditionTrue(MonitorConditionConfig condition, ObjectWrapper token) {
        MonitorCondition monitorCondition = null;
        boolean result = false;
        Class<?> conditionClass = null;
        Constructor<?> conditionConstructor = null;
        Throwable throwable = null;
        try {
            conditionClass = Class.forName(condition.getClassName());
            conditionConstructor = conditionClass.getConstructor(null);
            monitorCondition = (MonitorCondition)conditionConstructor.newInstance(null);
        }
        catch (ClassNotFoundException e) {
            throwable = e;
        }
        catch (NoSuchMethodException e) {
            throwable = e;
        }
        catch (IllegalAccessException e) {
            throwable = e;
        }
        catch (InstantiationException e) {
            throwable = e;
        }
        catch (InvocationTargetException e) {
            throwable = e.getCause() != null ? e.getCause() : e;
        }
        if (throwable == null) {
            if (monitorCondition != null) {
                try {
                    monitorCondition.init(condition.getArg());
                    result = monitorCondition.checkCondition(token).isTrue();
                    monitorCondition.terminate();
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "Unexpected exception caught while initializing a condition : " + e);
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        } else {
            new FrameworkLog(MonitorConstants.LOG_INFO, 1, throwable).log();
        }
        return result;
    }

    private boolean runActions(ArrayList actions, ObjectWrapper token, ArrayList actionsPerformed) {
        MonitorActionConfig action = null;
        boolean result = true;
        int successesSoFar = 0;
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            action = (MonitorActionConfig)i.next();
            successesSoFar = this.monitorMgr.getSuccessesSoFar(action.getConfigType().getName());
            if (successesSoFar >= action.getConfigType().getMaxSuccesses()) continue;
            if (!this.runAction(action, token, actionsPerformed)) {
                result = false;
                break;
            }
            this.monitorMgr.incSuccessesSoFar(action.getConfigType().getName());
        }
        return result;
    }

    private boolean runAction(MonitorActionConfig action, ObjectWrapper token, ArrayList actionsPerformed) {
        MonitorAction monitorAction = null;
        boolean result = false;
        Class<?> actionClass = null;
        Constructor<?> actionConstructor = null;
        MonitorActionTypeConfig actionType = null;
        Throwable throwable = null;
        actionType = (MonitorActionTypeConfig)this.actionTypes.get(action.getConfigType().getName());
        if (actionType != null) {
            try {
                actionClass = Class.forName(actionType.getClassName());
                actionConstructor = actionClass.getConstructor(null);
                monitorAction = (MonitorAction)actionConstructor.newInstance(null);
            }
            catch (ClassNotFoundException e) {
                throwable = e;
            }
            catch (NoSuchMethodException e) {
                throwable = e;
            }
            catch (IllegalAccessException e) {
                throwable = e;
            }
            catch (InstantiationException e) {
                throwable = e;
            }
            catch (InvocationTargetException e) {
                throwable = e.getCause() != null ? e.getCause() : e;
            }
            if (throwable == null) {
                if (monitorAction != null) {
                    try {
                        monitorAction.init(action.getArg());
                        result = monitorAction.runAction(token).isSuccessful();
                        if (result && action.getMark() != null && action.getMark().length() > 0) {
                            actionsPerformed.add(action.getMark());
                        }
                        monitorAction.terminate();
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKF, "Unexpected exception caught while initializing an action : " + e);
                        Trace.trace(TRACE_MASKF, e);
                    }
                }
            } else {
                new FrameworkLog(MonitorConstants.LOG_INFO, 2, throwable).log();
            }
        }
        return result;
    }

    private static boolean allActionsPerformedAlready(ArrayList configuredActions, ArrayList actionsPerformed) {
        MonitorActionConfig configuredAction = null;
        String markOfActionPerformed = null;
        boolean result = false;
        boolean matched = false;
        Trace.trace(TRACE_MASKT, "-> allActionsPerformedAlready(" + configuredActions + ", " + actionsPerformed + ")");
        if (configuredActions == null) {
            throw new IllegalArgumentException();
        }
        result = true;
        Iterator i = configuredActions.iterator();
        while (i.hasNext()) {
            configuredAction = (MonitorActionConfig)i.next();
            if (configuredAction.getMark() != null) {
                matched = false;
                Iterator i2 = actionsPerformed.iterator();
                while (i2.hasNext()) {
                    markOfActionPerformed = (String)i2.next();
                    if (!configuredAction.getMark().equals(markOfActionPerformed)) continue;
                    matched = true;
                    break;
                }
            } else {
                matched = true;
            }
            if (matched) continue;
            result = false;
            break;
        }
        Trace.trace(TRACE_MASKT, "<- allActionsPerformedAlready(...) returning " + result);
        return result;
    }

    private boolean maxSuccessesAlreadyForAllActions(ArrayList configuredActions, ArrayList actionsPerformed) {
        MonitorActionConfig configuredAction = null;
        boolean result = false;
        int successesSoFar = 0;
        Trace.trace(TRACE_MASKT, "-> maxSuccessesAlready(" + configuredActions + ", " + actionsPerformed + ")");
        if (configuredActions == null) {
            throw new IllegalArgumentException();
        }
        result = true;
        Iterator i = configuredActions.iterator();
        while (i.hasNext()) {
            configuredAction = (MonitorActionConfig)i.next();
            successesSoFar = this.monitorMgr.getSuccessesSoFar(configuredAction.getConfigType().getName());
            if (successesSoFar >= configuredAction.getConfigType().getMaxSuccesses()) continue;
            result = false;
            break;
        }
        Trace.trace(TRACE_MASKT, "<- maxSuccessesAlready(...) returning " + result);
        return result;
    }
}

